// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.application

import ksp.com.fasterxml.aalto.`in`.ReaderConfig
import ksp.com.intellij.diagnostic.LoadingState
import ksp.com.intellij.openapi.util.SystemInfoRt
import ksp.com.intellij.openapi.util.text.Strings
import ksp.com.intellij.util.lang.UrlClassLoader
import ksp.com.sun.jna.TypeMapper
import ksp.com.sun.jna.platform.FileUtils
import ksp.it.unimi.dsi.fastutil.objects.Object2IntMap
import ksp.net.jpountz.lz4.LZ4Factory
import ksp.org.apache.log4j.Appender
import org.apache.oro.text.regex.PatternMatcher
import ksp.org.codehaus.stax2.XMLStreamReader2
import ksp.org.intellij.lang.annotations.Flow
import ksp.org.jdom.Document
import ksp.org.jetbrains.annotations.ApiStatus

@ApiStatus.Internal
object ClassPathUtil {
  @JvmStatic
  fun getUtilClassPath(): Collection<String> {
    val classes = getUtilClasses()
    val result = classes.mapNotNullTo(HashSet(classes.size), PathManager::getJarPathForClass)
    addKotlinStdlib(result)
    return result
  }

  @JvmStatic
  fun addKotlinStdlib(classPath: MutableCollection<String>) {
    val classLoader = PathManager::class.java.classLoader
    PathManager.getResourceRoot(classLoader, "kotlin/jdk7/AutoCloseableKt.class")?.let(classPath::add) // kotlin-stdlib-jdk7
    PathManager.getResourceRoot(classLoader, "kotlin/streams/jdk8/StreamsKt.class")?.let(classPath::add) // kotlin-stdlib-jdk8
    PathManager.getResourceRoot(classLoader, "gnu/trove/THashSet.class")?.let(classPath::add) // Trove
  }

  @JvmStatic
  fun getUtilClasses(): Array<Class<*>> {
    val classLoader = ClassPathUtil::class.java.classLoader
    return arrayOf(
      LoadingState::class.java,  // module 'intellij.platform.diagnostic'
      PathManager::class.java,  // module 'intellij.platform.util'
      Strings::class.java,  // module 'intellij.platform.util.base'
      classLoader.loadClass("com.intellij.util.xml.dom.XmlDomReader"),  // module 'intellij.platform.util.xmlDom'
      SystemInfoRt::class.java,  // module 'intellij.platform.util.rt'
      UrlClassLoader::class.java,  // module 'intellij.platform.util.classLoader'
      classLoader.loadClass("com.intellij.util.lang.Xx3UnencodedString"),  // intellij.platform.util.rt.java8 (required for classLoader)
      Flow::class.java,  // jetbrains-annotations
      Document::class.java,  // jDOM
      Appender::class.java,  // Log4J
      Object2IntMap::class.java,  // fastutil
      TypeMapper::class.java,  // JNA
      FileUtils::class.java,  // JNA (jna-platform)
      PatternMatcher::class.java,  // OROMatcher
      LZ4Factory::class.java,  // LZ4-Java
      ReaderConfig::class.java,  // Aalto XML
      XMLStreamReader2::class.java,  // Aalto XML
      Pair::class.java)
  }
}