// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.openapi.application.impl

import ksp.com.intellij.openapi.application.ModalityState
import ksp.org.jetbrains.annotations.ApiStatus.Internal

@Internal
fun <T> inModalContext(modalJob: JobProvider, action: (ModalityState) -> T): T {
  val newModalityState = LaterInvocator.getCurrentModalityState().appendEntity(modalJob)
  LaterInvocator.enterModal(modalJob, newModalityState)
  try {
    return action(newModalityState)
  }
  finally {
    LaterInvocator.leaveModal(modalJob)
  }
}
