// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.openapi.roots;

import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.util.messages.Topic;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

/**
 * @author Dmitry Avdeev
 */
public abstract class LanguageLevelProjectExtension {
  public static final Topic<LanguageLevelChangeListener> LANGUAGE_LEVEL_CHANGED_TOPIC =
    Topic.create("Java language level", LanguageLevelChangeListener.class);

  public static LanguageLevelProjectExtension getInstance(Project project) {
    return project.getService(LanguageLevelProjectExtension.class);
  }

  @NotNull
  public abstract LanguageLevel getLanguageLevel();

  public abstract void setLanguageLevel(@NotNull LanguageLevel languageLevel);

  private Boolean myDefault;

  /**
   * Auto-detect language level from project JDK maximum possible level.
   * @return null if the property is not set yet (e.g. after migration).
   */
  @Nullable
  public Boolean getDefault() {
    return myDefault;
  }

  public void setDefault(@Nullable Boolean value) {
    myDefault = value;
  }

  public boolean isDefault() {
    return myDefault != null && myDefault;
  }

  public void languageLevelsChanged() {
  }

  public interface LanguageLevelChangeListener {
    void onLanguageLevelsChanged();
  }
}
