// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.compiled.ClassFileDecompilers;
import ksp.org.jetbrains.annotations.NotNull;

import static com.intellij.psi.compiled.ClassFileDecompilers.Full;

public class ClassFileViewProviderFactory implements FileViewProviderFactory {
  @Override
  public @NotNull FileViewProvider createFileViewProvider(@NotNull VirtualFile file,
                                                          Language language,
                                                          @NotNull PsiManager manager,
                                                          boolean eventSystemEnabled) {
    Full decompiler = ClassFileDecompilers.getInstance().find(file, Full.class);
    return decompiler.createFileViewProvider(file, manager, eventSystemEnabled);
  }
}