// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * Register in extension point {@code com.intellij.fileType.fileViewProviderFactory}
 * or {@code com.intellij.lang.fileViewProviderFactory}.
 */
public interface FileViewProviderFactory {
  @NotNull
  FileViewProvider createFileViewProvider(@NotNull VirtualFile file, Language language, @NotNull PsiManager manager, boolean eventSystemEnabled);
}