// Copyright 2000-2019 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.impl;

import ksp.com.intellij.psi.*;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

import java.util.Map;

@ApiStatus.Internal
public class PsiSubstitutorFactoryImpl extends PsiSubstitutorFactory {
  @NotNull
  @Override
  protected PsiSubstitutor createSubstitutor(@NotNull PsiTypeParameter typeParameter, PsiType mapping) {
    return new PsiSubstitutorImpl(typeParameter, mapping);
  }

  @NotNull
  @Override
  protected PsiSubstitutor createSubstitutor(@NotNull PsiClass aClass, PsiType[] mappings) {
    return new PsiSubstitutorImpl(aClass, mappings);
  }
  
  @NotNull
  @Override
  protected PsiSubstitutor createSubstitutor(@NotNull Map<? extends PsiTypeParameter, ? extends PsiType> map) {
    return new PsiSubstitutorImpl(map);
  }
}
