// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl.source.javadoc;

import ksp.com.intellij.psi.JavaDocTokenType;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.JavaDocElementType;
import ksp.com.intellij.psi.javadoc.PsiSnippetAttribute;
import ksp.com.intellij.psi.javadoc.PsiSnippetAttributeValue;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class PsiSnippetAttributeImpl extends CompositePsiElement implements PsiSnippetAttribute {
  public PsiSnippetAttributeImpl() {
    super(JavaDocElementType.DOC_SNIPPET_ATTRIBUTE);
  }

  @Override
  public @NotNull PsiElement getNameIdentifier() {
    return Objects.requireNonNull(findPsiChildByType(JavaDocTokenType.DOC_TAG_ATTRIBUTE_NAME));
  }

  @Override
  public void accept(@NotNull PsiElementVisitor visitor) {
    super.accept(visitor);
    if (visitor instanceof JavaElementVisitor) {
      ((JavaElementVisitor)visitor).visitSnippetAttribute(this);
    }
    else {
      visitor.visitElement(this);
    }
  }

  @Override
  public String getName() {
    return getNameIdentifier().getText();
  }

  @Override
  public @Nullable PsiSnippetAttributeValue getValue() {
    return (PsiSnippetAttributeValue)findPsiChildByType(JavaDocElementType.DOC_SNIPPET_ATTRIBUTE_VALUE);
  }

  @Override
  public String toString() {
    return "PsiSnippetAttribute:" + getName();
  }
}
