// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.impl.source.resolve.reference;

import ksp.com.intellij.lang.Language;
import ksp.com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import ksp.com.intellij.psi.PsiReferenceContributor;
import ksp.com.intellij.util.KeyedLazyInstance;
import ksp.com.intellij.util.xmlb.annotations.Attribute;
import ksp.org.jetbrains.annotations.Nullable;

public final class PsiReferenceContributorEP extends CustomLoadingExtensionPointBean<PsiReferenceContributor> implements KeyedLazyInstance<PsiReferenceContributor> {
  @Attribute("language")
  public String language = Language.ANY.getID();

  @Attribute("implementation")
  public String implementationClass;

  @Override
  public String getKey() {
    return language;
  }

  @Override
  protected @Nullable String getImplementationClassName() {
    return implementationClass;
  }
}
