// Copyright 2000-2021 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.psi.javadoc;

import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * Represents elements starting from ':' (inclusive) and until '}' (exclusive) in @snippet javadoc tag.
 * @see PsiSnippetDocTag
 */
@ApiStatus.Experimental
public interface PsiSnippetDocTagBody extends PsiElement {
  /**
   * @return elements which text makes up snippet (without leading *)
   */
  PsiElement @NotNull [] getContent();
}
