// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.psi.presentation.java;

import ksp.com.intellij.navigation.ItemPresentation;
import ksp.com.intellij.navigation.ItemPresentationProvider;
import ksp.com.intellij.psi.PsiField;
import ksp.org.jetbrains.annotations.NotNull;


public class FieldPresentationProvider implements ItemPresentationProvider<PsiField> {
  @Override
  public ItemPresentation getPresentation(@NotNull PsiField item) {
    return JavaPresentationUtil.getFieldPresentation(item);
  }
}
