// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util

import ksp.com.intellij.util.containers.ConcurrentLongObjectMap
import ksp.org.jetbrains.annotations.ApiStatus
import java.util.*

@ApiStatus.Internal
// implementation of `copyOf` is allowed to not do copy - it can return the same map, read `copyOf` as `immutable`
interface Java11Shim {
  companion object {
    var INSTANCE: Java11Shim = object : Java11Shim {
      override fun <K, V> copyOf(map: Map<K, V>): Map<K, V> = Collections.unmodifiableMap(map)

      override fun <E> copyOf(collection: Collection<E>): Set<E> = Collections.unmodifiableSet(HashSet(collection))

      override fun <E> copyOfCollection(collection: Collection<E>): List<E> = Collections.unmodifiableList(ArrayList(collection))

      override fun <E> setOf(collection: Array<E>): Set<E> = HashSet(collection.asList())

      override fun <V : Any> createConcurrentLongObjectMap(): ConcurrentLongObjectMap<V> {
        return ConcurrentLongObjectHashMap()
      }
    }
  }

  fun <K, V : Any?> copyOf(map: Map<K, V>): Map<K, V>

  fun <E> copyOf(collection: Collection<E>): Set<E>

  fun <E> setOf(collection: Array<E>): Set<E>

  fun <E> copyOfCollection(collection: Collection<E>): List<E>

  fun <V : Any> createConcurrentLongObjectMap(): ConcurrentLongObjectMap<V>
}
