// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util

import ksp.com.intellij.ide.IconProvider
import ksp.com.intellij.openapi.project.DumbService
import ksp.com.intellij.openapi.project.DumbService.Companion.isDumbAware
import ksp.com.intellij.openapi.util.Iconable.IconFlags
import ksp.com.intellij.psi.PsiElement
import javax.swing.Icon

object PsiIconUtil {
  @JvmStatic
  @Suppress("IdentifierGrammar")
  fun getProvidersIcon(element: PsiElement, @IconFlags flags: Int): Icon? {
    val isDumb = DumbService.getInstance(element.getProject()).isDumb
    for (provider in IconProvider.EXTENSION_POINT_NAME.getIterable()) {
      if (provider == null || (isDumb && !isDumbAware(provider))) {
        continue
      }
      provider.getIcon(element, flags)?.let {
        return it
      }
    }
    return null
  }
}