// Copyright 2000-2022 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.util.xmlb;

import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.xml.dom.XmlElement;
import ksp.org.jdom.Element;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public abstract class NotNullDeserializeBinding implements Binding {
  @SuppressWarnings("LoggerInitializedWithForeignClass")
  protected static final Logger LOG = Logger.getInstance(Binding.class);

  public abstract @NotNull Object deserialize(@Nullable Object context, @NotNull Element element);

  public abstract @NotNull Object deserialize(@Nullable Object context, @NotNull XmlElement element);

  @Override
  public final Object deserializeUnsafe(Object context, @NotNull Element element) {
    return deserialize(context, element);
  }

  @Override
  public final Object deserializeUnsafe(Object context, @NotNull XmlElement element) {
    return deserialize(context, element);
  }
}
