/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.annotations

import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeOwner
import ksp.org.jetbrains.kotlin.name.Name

/**
 * Name-Value pair which is used as annotation argument.
 */
public interface KaNamedAnnotationValue : KaLifetimeOwner {
    public val name: Name
    public val expression: KaAnnotationValue
}

@Deprecated("Use 'KaNamedAnnotationValue' instead", ReplaceWith("KaNamedAnnotationValue"))
public typealias KtNamedAnnotationValue = KaNamedAnnotationValue
