/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.fir.references

import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession
import ksp.org.jetbrains.kotlin.analysis.api.fir.buildSymbol
import ksp.org.jetbrains.kotlin.analysis.api.fir.getCalleeSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbol
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.getOrBuildFirSafe
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.expressions.FirComponentCall
import ksp.org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry
import ksp.org.jetbrains.kotlin.psi.KtImportAlias

internal class KaFirDestructuringDeclarationReference(
    element: KtDestructuringDeclarationEntry
) : KtDestructuringDeclarationReference(element), KaFirReference {
    override fun canRename(): Boolean = false //todo

    override fun KaSession.resolveToSymbols(): Collection<KaSymbol> {
        check(this is KaFirSession)
        val fir = expression.getOrBuildFirSafe<FirProperty>(firResolveSession) ?: return emptyList()
        return listOfNotNull(
            fir.buildSymbol(firSymbolBuilder),
            getComponentNSymbol(fir)
        )
    }

    private fun KaFirSession.getComponentNSymbol(fir: FirProperty): KaSymbol? {
        val componentFunctionSymbol = (fir.initializer as? FirComponentCall)?.getCalleeSymbol() ?: return null
        return componentFunctionSymbol.fir.buildSymbol(firSymbolBuilder)
    }

    override fun isReferenceToImportAlias(alias: KtImportAlias): Boolean {
        return super<KaFirReference>.isReferenceToImportAlias(alias)
    }

}
