/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.impl.base.components

import ksp.org.jetbrains.kotlin.analysis.api.KaImplementationDetail
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.withValidityAssertion
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol
import ksp.org.jetbrains.kotlin.analysis.api.symbols.KaSymbolProvider
import ksp.org.jetbrains.kotlin.psi.KtClassInitializer
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject
import ksp.org.jetbrains.kotlin.psi.KtConstructor
import ksp.org.jetbrains.kotlin.psi.KtDeclaration
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry
import ksp.org.jetbrains.kotlin.psi.KtEnumEntry
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral
import ksp.org.jetbrains.kotlin.psi.KtNamedFunction
import ksp.org.jetbrains.kotlin.psi.KtObjectDeclaration
import ksp.org.jetbrains.kotlin.psi.KtParameter
import ksp.org.jetbrains.kotlin.psi.KtProperty
import ksp.org.jetbrains.kotlin.psi.KtPropertyAccessor
import ksp.org.jetbrains.kotlin.psi.KtScript
import ksp.org.jetbrains.kotlin.psi.KtScriptInitializer
import ksp.org.jetbrains.kotlin.psi.KtTypeAlias
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter

@KaImplementationDetail
abstract class KaBaseSymbolProvider<T : KaSession> : KaSessionComponent<T>(), KaSymbolProvider {
    override val KtDeclaration.symbol: KaDeclarationSymbol
        get() = withValidityAssertion {
            when (this) {
                is KtParameter -> symbol
                is KtNamedFunction -> symbol
                is KtConstructor<*> -> symbol
                is KtTypeParameter -> symbol
                is KtTypeAlias -> symbol
                is KtEnumEntry -> symbol
                is KtFunctionLiteral -> symbol
                is KtProperty -> symbol
                is KtObjectDeclaration -> symbol
                is KtClassOrObject -> classSymbol!!
                is KtPropertyAccessor -> symbol
                is KtClassInitializer -> symbol
                is KtDestructuringDeclarationEntry -> symbol
                is KtScript -> symbol
                is KtScriptInitializer -> containingDeclaration.symbol
                is KtDestructuringDeclaration -> symbol
                else -> error("Cannot build symbol for ${this::class}")
            }
        }
}
