/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.renderer.types.renderers

import ksp.org.jetbrains.kotlin.analysis.api.KaExperimentalApi
import ksp.org.jetbrains.kotlin.analysis.api.KaSession
import ksp.org.jetbrains.kotlin.analysis.api.renderer.types.KaTypeRenderer
import ksp.org.jetbrains.kotlin.analysis.api.types.KaTypeNullability
import ksp.org.jetbrains.kotlin.analysis.api.types.KaTypeParameterType
import ksp.org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter

@KaExperimentalApi
public interface KaTypeParameterTypeRenderer {
    public fun renderType(
        analysisSession: KaSession,
        type: KaTypeParameterType,
        typeRenderer: KaTypeRenderer,
        printer: PrettyPrinter,
    )

    @KaExperimentalApi
    public object AS_SOURCE : KaTypeParameterTypeRenderer {
        override fun renderType(
            analysisSession: KaSession,
            type: KaTypeParameterType,
            typeRenderer: KaTypeRenderer,
            printer: PrettyPrinter,
        ) {
            printer {
                " ".separated(
                    { typeRenderer.annotationsRenderer.renderAnnotations(analysisSession, type, printer) },
                    {
                        typeRenderer.typeNameRenderer.renderName(analysisSession, type.name, type, typeRenderer, printer)
                        if (type.nullability == KaTypeNullability.NULLABLE) {
                            printer.append('?')
                        }
                    }
                )

            }
        }
    }
}

@KaExperimentalApi
@Deprecated("Use 'KaTypeParameterTypeRenderer' instead", ReplaceWith("KaTypeParameterTypeRenderer"))
public typealias KtTypeParameterTypeRenderer = KaTypeParameterTypeRenderer