/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.api.standalone

import ksp.com.intellij.core.CoreApplicationEnvironment
import ksp.com.intellij.mock.MockProject
import ksp.com.intellij.openapi.application.Application
import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.PsiFile
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.platform.packages.createPackagePartProvider
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule
import ksp.org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment
import ksp.org.jetbrains.kotlin.load.kotlin.PackagePartProvider

public class StandaloneAnalysisAPISession internal constructor(
    kotlinCoreProjectEnvironment: KotlinCoreProjectEnvironment,
    modulesWithFilesProvider: () -> Map<KaSourceModule, List<PsiFile>>
) {
    // TODO: better to limit exposure? Current usages are: addExtension, jarFileSystem
    public val coreApplicationEnvironment: CoreApplicationEnvironment = kotlinCoreProjectEnvironment.environment

    public val application: Application = kotlinCoreProjectEnvironment.environment.application

    public val project: Project = kotlinCoreProjectEnvironment.project

    @Deprecated(
        "Use session builder's service registration.",
        ReplaceWith("project")
    )
    public val mockProject: MockProject = kotlinCoreProjectEnvironment.project

    /**
     * @see org.jetbrains.kotlin.analysis.api.platform.packages.createPackagePartProvider
     */
    @Deprecated(
        "Use PackagePartProviderFactory instead.",
        ReplaceWith("project::createPackagePartProvider")
    )
    public val createPackagePartProvider: (GlobalSearchScope) -> PackagePartProvider
        get() = project::createPackagePartProvider

    public val modulesWithFiles: Map<KaSourceModule, List<PsiFile>> by lazy(modulesWithFilesProvider)
}