/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions

import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule
import ksp.org.jetbrains.kotlin.fir.BuiltinTypes
import ksp.org.jetbrains.kotlin.fir.PrivateSessionConstructor

internal class LLFirDanglingFileSession @PrivateSessionConstructor constructor(
    ktModule: KaDanglingFileModule,
    override val moduleComponents: LLFirModuleResolveComponents,
    builtinTypes: BuiltinTypes,
    val modificationStamp: Long
) : LLFirResolvableModuleSession(ktModule, builtinTypes)
