/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm

import ksp.org.jetbrains.kotlin.ir.IrBuiltIns
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass
import ksp.org.jetbrains.kotlin.ir.linkage.IrProvider
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable

interface JvmIrDeserializer {
    fun deserializeTopLevelClass(
        irClass: IrClass,
        irBuiltIns: IrBuiltIns,
        symbolTable: SymbolTable,
        irProviders: List<IrProvider>,
        extensions: JvmGeneratorExtensions,
    ): Boolean
}
