/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm

import ksp.org.jetbrains.kotlin.backend.common.lower.*
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ForLoopsLowering
import ksp.org.jetbrains.kotlin.backend.common.phaser.*
import ksp.org.jetbrains.kotlin.backend.jvm.lower.*

private val jvmFilePhases = createFilePhases<JvmBackendContext>(
    ::TypeAliasAnnotationMethodsLowering,
    ::ProvisionalFunctionExpressionLowering,

    ::JvmOverloadsAnnotationLowering,
    ::MainMethodGenerationLowering,

    ::AnnotationLowering,
    ::JvmAnnotationImplementationLowering,
    ::PolymorphicSignatureLowering,
    ::VarargLowering,

    ::JvmLateinitLowering,
    ::JvmInventNamesForLocalClasses,

    ::JvmInlineCallableReferenceToLambdaPhase,
    ::DirectInvokeLowering,
    ::FunctionReferenceLowering,

    ::SuspendLambdaLowering,
    ::PropertyReferenceDelegationLowering,
    ::SingletonOrConstantDelegationLowering,
    ::PropertyReferenceLowering,
    ::ArrayConstructorLowering,

    // TODO: merge the next three phases together, as visitors behave incorrectly between them
    //  (backing fields moved out of companion objects are reachable by two paths):
    ::MoveOrCopyCompanionObjectFieldsLowering,
    ::JvmPropertiesLowering,
    ::RemapObjectFieldAccesses,

    ::AnonymousObjectSuperConstructorLowering,
    ::JvmBuiltInsLowering,

    ::RangeContainsLowering,
    ::ForLoopsLowering,
    ::CollectionStubMethodLowering,
    ::JvmSingleAbstractMethodLowering,
    ::JvmMultiFieldValueClassLowering,
    ::JvmInlineClassLowering,
    ::JvmTailrecLowering,

    ::MappedEnumWhenLowering,

    ::AssertionLowering,
    ::JvmReturnableBlockLowering,
    ::SingletonReferencesLowering,
    ::SharedVariablesLowering,
    ::JvmLocalDeclarationsLowering,

    ::RemoveDuplicatedInlinedLocalClassesLowering,

    ::JvmLocalClassPopupLowering,
    ::StaticCallableReferenceLowering,

    ::JvmDefaultConstructorLowering,

    ::FlattenStringConcatenationLowering,
    ::JvmStringConcatenationLowering,

    ::JvmDefaultArgumentStubGenerator,
    ::JvmDefaultParameterInjector,
    ::JvmDefaultParameterCleaner,

    ::FragmentLocalFunctionPatchLowering,

    ::InterfaceLowering,
    ::InheritedDefaultMethodsOnClassesLowering,
    ::InterfaceSuperCallsLowering,
    ::InterfaceDefaultCallsLowering,
    ::InterfaceObjectCallsLowering,

    ::TailCallOptimizationLowering,
    ::AddContinuationLowering,

    ::JvmInnerClassesLowering,
    ::JvmInnerClassesMemberBodyLowering,
    ::JvmInnerClassConstructorCallsLowering,

    ::EnumClassLowering,
    ::EnumExternalEntriesLowering,
    ::ObjectClassLowering,
    ::StaticInitializersLowering,
    ::UniqueLoopLabelsLowering,
    ::JvmInitializersLowering,
    ::JvmInitializersCleanupLowering,
    ::FunctionNVarargBridgeLowering,
    ::JvmStaticInCompanionLowering,
    ::StaticDefaultFunctionLowering,
    ::BridgeLowering,
    ::SyntheticAccessorLowering,

    ::JvmArgumentNullabilityAssertionsLowering,
    ::ToArrayLowering,
    ::JvmSafeCallChainFoldingLowering,
    ::JvmOptimizationLowering,
    ::AdditionalClassAnnotationLowering,
    ::RecordEnclosingMethodsLowering,
    ::TypeOperatorLowering,
    ::ReplaceKFunctionInvokeWithFunctionInvoke,
    ::JvmKotlinNothingValueExceptionLowering,
    ::MakePropertyDelegateMethodsStaticLowering,
    ::ReplaceNumberToCharCallSitesLowering,

    ::RenameFieldsLowering,
    ::FakeLocalVariablesForBytecodeInlinerLowering,
    ::FakeLocalVariablesForIrInlinerLowering,

    ::SpecialAccessLowering,
)

val jvmLoweringPhases = SameTypeNamedCompilerPhase(
    name = "IrLowering",
    nlevels = 1,
    actions = DEFAULT_IR_ACTIONS,
    lower = buildModuleLoweringsPhase(
        ::ExternalPackageParentPatcherLowering,
        ::FragmentSharedVariablesLowering,
        ::JvmIrValidationBeforeLoweringPhase,
        ::ProcessOptionalAnnotations,
        ::JvmExpectDeclarationRemover,
        ::ConstEvaluationLowering,
        ::SerializeIrPhase,
        ::ScriptsToClassesLowering,
        ::FileClassLowering,
        ::JvmStaticInObjectLowering,
        ::RepeatedAnnotationLowering,
        ::JvmInlineCallableReferenceToLambdaWithDefaultsPhase,

        ::JvmIrInliner,
        ::ApiVersionIsAtLeastEvaluationLowering,
        ::CreateSeparateCallForInlinedLambdasLowering,
        ::MarkNecessaryInlinedClassesAsRegeneratedLowering,
        ::InlinedClassReferencesBoxingLowering,
        ::RestoreInlineLambda,
    ).then(
        performByIrFile(
            name = "PerformByIrFile",
            lower = jvmFilePhases,
            supportParallel = false,
        )
    ) then buildModuleLoweringsPhase(
        ::GenerateMultifileFacades,
        ::ResolveInlineCalls,
        ::JvmIrValidationAfterLoweringPhase
    )
)
