/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.backend.jvm.codegen

import ksp.org.jetbrains.kotlin.ir.IrDiagnosticReporter
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration
import ksp.org.jetbrains.kotlin.ir.declarations.IrField
import ksp.org.jetbrains.kotlin.ir.descriptors.toIrBasedDescriptor
import ksp.org.jetbrains.kotlin.ir.linkage.SignatureClashDetector
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ConflictingJvmDeclarationsData
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmBackendErrors
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.RawSignature

internal class JvmFieldSignatureClashDetector(
    private val classCodegen: ClassCodegen,
) : SignatureClashDetector<RawSignature, IrField>() {

    override fun reportSignatureConflict(
        signature: RawSignature,
        declarations: Collection<IrField>,
        diagnosticReporter: IrDiagnosticReporter
    ) {
        reportSignatureClashTo(
            diagnosticReporter,
            JvmBackendErrors.CONFLICTING_JVM_DECLARATIONS,
            declarations,
            ConflictingJvmDeclarationsData(
                classInternalName = classCodegen.type.internalName,
                classOrigin = null,
                signature = signature,
                signatureOrigins = null,
                signatureDescriptors = declarations.map(IrDeclaration::toIrBasedDescriptor),
            ),
            reportOnIfSynthetic = { classCodegen.irClass },
        )
    }
}