/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.codegen

import ksp.org.jetbrains.kotlin.descriptors.ClassKind
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor
import ksp.org.jetbrains.kotlin.descriptors.Modality
import ksp.org.jetbrains.kotlin.descriptors.impl.ClassDescriptorImpl
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.psi.KtCallableReferenceExpression
import ksp.org.jetbrains.kotlin.psi.KtElement
import ksp.org.jetbrains.kotlin.resolve.scopes.MemberScope
import ksp.org.jetbrains.kotlin.resolve.source.getPsi
import ksp.org.jetbrains.kotlin.resolve.source.toSourceElement
import ksp.org.jetbrains.kotlin.storage.LockBasedStorageManager
import ksp.org.jetbrains.kotlin.types.KotlinType

class SyntheticClassDescriptorForLambda(
        containingDeclaration: DeclarationDescriptor,
        name: Name,
        supertypes: Collection<KotlinType>,
        element: KtElement
) : ClassDescriptorImpl(containingDeclaration, name, Modality.FINAL, ClassKind.CLASS, supertypes, element.toSourceElement(),
                        /* isExternal = */ false, LockBasedStorageManager.NO_LOCKS) {
    init {
        initialize(MemberScope.Empty, emptySet(), null)
    }

    fun isCallableReference(): Boolean = source.getPsi() is KtCallableReferenceExpression
}
