/*
 * Copyright 2000-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.codegen.range

import ksp.org.jetbrains.kotlin.builtins.KotlinBuiltIns
import ksp.org.jetbrains.kotlin.codegen.ExpressionCodegen
import ksp.org.jetbrains.kotlin.codegen.range.forLoop.CharSequenceWithIndexForLoopGenerator
import ksp.org.jetbrains.kotlin.codegen.range.forLoop.ForLoopGenerator
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor
import ksp.org.jetbrains.kotlin.psi.KtDestructuringDeclaration
import ksp.org.jetbrains.kotlin.psi.KtForExpression
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall

class CharSequenceWithIndexRangeValue(rangeCall: ResolvedCall<out CallableDescriptor>) : AbstractDestructuredPairRangeValue(rangeCall) {

    override fun createDestructuredPairForLoopGenerator(
        codegen: ExpressionCodegen,
        forExpression: KtForExpression,
        loopParameter: KtDestructuringDeclaration,
        rangeCall: ResolvedCall<out CallableDescriptor>
    ): ForLoopGenerator =
        CharSequenceWithIndexForLoopGenerator(
            codegen, forExpression, loopParameter, rangeCall,
            canCacheLength = canCacheLength(rangeCall)
        )

    private fun canCacheLength(rangeCall: ResolvedCall<out CallableDescriptor>): Boolean {
        val receiverType = rangeCall.extensionReceiver?.type ?: return false
        return KotlinBuiltIns.isString(receiverType)
    }

}