/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration

import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass

object FirContextReceiversDeprecatedDeclarationChecker : FirBasicDeclarationChecker(MppCheckerKind.Common) {
    override fun check(declaration: FirDeclaration, context: CheckerContext, reporter: DiagnosticReporter) {
        if (declaration is FirCallableDeclaration &&
            // Skip the lambdas. They don't have `context` explicitly written => `context` is written somewhere else.
            // Plus, I'd not say that lambdas are declarations. They are rather values
            declaration !is FirAnonymousFunction &&
            declaration.contextReceivers.isNotEmpty()
        ) {
            reporter.reportOn(declaration.source, FirErrors.CONTEXT_RECEIVERS_DEPRECATED, context)
        }
        if (declaration is FirRegularClass && declaration.contextReceivers.isNotEmpty()) {
            reporter.reportOn(declaration.source, FirErrors.CONTEXT_RECEIVERS_DEPRECATED, context)
        }
    }
}
