/*
 * Copyright 2010-2021 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration

import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter
import ksp.org.jetbrains.kotlin.diagnostics.reportOn
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty
import ksp.org.jetbrains.kotlin.fir.declarations.utils.hasBackingField
import ksp.org.jetbrains.kotlin.fir.declarations.utils.isInline

object FirInlinePropertyChecker : FirPropertyChecker(MppCheckerKind.Common) {
    override fun check(declaration: FirProperty, context: CheckerContext, reporter: DiagnosticReporter) {
        if (declaration.getter?.isInline != true && declaration.setter?.isInline != true) return

        FirInlineDeclarationChecker.checkCallableDeclaration(declaration, context, reporter)

        if (declaration.hasBackingField || declaration.delegate != null) {
            when (declaration.source?.kind) {
                KtFakeSourceElementKind.PropertyFromParameter -> reporter.reportOn(
                    declaration.source, FirErrors.INLINE_PROPERTY_WITH_BACKING_FIELD_DEPRECATION, context
                )
                else -> reporter.reportOn(
                    declaration.source, FirErrors.INLINE_PROPERTY_WITH_BACKING_FIELD, context
                )
            }
        }
    }
}
