/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.declarations

import ksp.org.jetbrains.kotlin.fir.resolve.SessionHolder
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValueForScript
import ksp.org.jetbrains.kotlin.fir.scopes.FirScope
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirScriptDeclarationsScope
import ksp.org.jetbrains.kotlin.fir.symbols.lazyResolveToPhase
import ksp.org.jetbrains.kotlin.fir.types.coneType

class TowerElementsForScript(
    val implicitReceivers: List<ImplicitReceiverValueForScript>,
    val staticScope: FirScope?,
)

fun SessionHolder.collectTowerDataElementsForScript(owner: FirScript): TowerElementsForScript {
    owner.lazyResolveToPhase(FirResolvePhase.TYPES)

    val contextReceivers = owner.receivers.mapIndexed { index, receiver ->
        ImplicitReceiverValueForScript(owner.symbol, receiver.typeRef.coneType, session, scopeSession, receiverNumber = index)
    }.asReversed()

    return TowerElementsForScript(
        contextReceivers,
        FirScriptDeclarationsScope(session, owner),
    )
}
