/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.declarations.synthetic

import ksp.org.jetbrains.kotlin.fir.FirImplementationDetail
import ksp.org.jetbrains.kotlin.fir.FirModuleData
import ksp.org.jetbrains.kotlin.fir.declarations.DeprecationsProvider
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType
import ksp.org.jetbrains.kotlin.name.Name

class FirSyntheticPropertyBuilder {
    lateinit var moduleData: FirModuleData
    lateinit var name: Name
    lateinit var symbol: FirSyntheticPropertySymbol
    lateinit var delegateGetter: FirSimpleFunction
    lateinit var deprecationsProvider: DeprecationsProvider

    var status: FirDeclarationStatus? = null
    var delegateSetter: FirSimpleFunction? = null
    var dispatchReceiverType: ConeSimpleKotlinType? = null


    @OptIn(FirImplementationDetail::class)
    fun build(): FirSyntheticProperty = FirSyntheticProperty(
        moduleData, name, isVar = delegateSetter != null, symbol = symbol,
        status = status ?: delegateGetter.status,
        getter = FirSyntheticPropertyAccessor(delegateGetter, isGetter = true, symbol),
        setter = delegateSetter?.let { FirSyntheticPropertyAccessor(it, isGetter = false, symbol) },
        dispatchReceiverType = dispatchReceiverType ?: delegateGetter.dispatchReceiverType,
        deprecationsProvider = deprecationsProvider
    )
}

fun buildSyntheticProperty(f: FirSyntheticPropertyBuilder.() -> Unit): FirSyntheticProperty =
    FirSyntheticPropertyBuilder().apply { f() }.build()
