/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

// This file was generated automatically. See compiler/fir/tree/tree-generator/Readme.md.
// DO NOT MODIFY IT MANUALLY.

@file:Suppress("DuplicatedCode")

package ksp.org.jetbrains.kotlin.fir.expressions.impl

import ksp.org.jetbrains.kotlin.KtSourceElement
import ksp.org.jetbrains.kotlin.fir.FirImplementationDetail
import ksp.org.jetbrains.kotlin.fir.expressions.*
import ksp.org.jetbrains.kotlin.fir.references.FirReference
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor
import ksp.org.jetbrains.kotlin.fir.visitors.transformInplace

class FirMultiDelegatedConstructorCallImpl @FirImplementationDetail constructor(
    override val delegatedConstructorCalls: MutableList<FirDelegatedConstructorCall>,
) : FirMultiDelegatedConstructorCall() {
    override val annotations: List<FirAnnotation>
        get() = delegatedConstructorCalls.last().annotations
    override val argumentList: FirArgumentList
        get() = delegatedConstructorCalls.last().argumentList
    override val contextReceiverArguments: List<FirExpression>
        get() = delegatedConstructorCalls.last().contextReceiverArguments
    @OptIn(UnresolvedExpressionTypeAccess::class)
    override val coneTypeOrNull: ConeKotlinType?
        get() = delegatedConstructorCalls.last().coneTypeOrNull
    override val constructedTypeRef: FirTypeRef
        get() = delegatedConstructorCalls.last().constructedTypeRef
    override val dispatchReceiver: FirExpression?
        get() = delegatedConstructorCalls.last().dispatchReceiver
    override val calleeReference: FirReference
        get() = delegatedConstructorCalls.last().calleeReference
    override val source: KtSourceElement?
        get() = delegatedConstructorCalls.last().source
    override val isThis: Boolean
        get() = delegatedConstructorCalls.last().isThis
    override val isSuper: Boolean
        get() = !isThis

    override fun <R, D> acceptChildren(visitor: FirVisitor<R, D>, data: D) {
        delegatedConstructorCalls.forEach { it.accept(visitor, data) }
    }

    override fun <D> transformChildren(transformer: FirTransformer<D>, data: D): FirMultiDelegatedConstructorCallImpl {
        transformDelegatedConstructorCalls(transformer, data)
        return this
    }

    override fun <D> transformAnnotations(transformer: FirTransformer<D>, data: D): FirMultiDelegatedConstructorCallImpl {
        return this
    }

    override fun <D> transformDispatchReceiver(transformer: FirTransformer<D>, data: D): FirMultiDelegatedConstructorCallImpl {
        return this
    }

    override fun <D> transformCalleeReference(transformer: FirTransformer<D>, data: D): FirMultiDelegatedConstructorCallImpl {
        return this
    }

    override fun <D> transformDelegatedConstructorCalls(transformer: FirTransformer<D>, data: D): FirMultiDelegatedConstructorCallImpl {
        delegatedConstructorCalls.transformInplace(transformer, data)
        return this
    }

    override fun replaceAnnotations(newAnnotations: List<FirAnnotation>) {}

    override fun replaceArgumentList(newArgumentList: FirArgumentList) {}

    override fun replaceContextReceiverArguments(newContextReceiverArguments: List<FirExpression>) {}

    override fun replaceConeTypeOrNull(newConeTypeOrNull: ConeKotlinType?) {
        require(newConeTypeOrNull == coneTypeOrNull) { "${javaClass.simpleName}.replaceConeTypeOrNull() called with invalid type '${newConeTypeOrNull}'. Current type is '$coneTypeOrNull'" }
    }

    override fun replaceConstructedTypeRef(newConstructedTypeRef: FirTypeRef) {}

    override fun replaceDispatchReceiver(newDispatchReceiver: FirExpression?) {}

    override fun replaceCalleeReference(newCalleeReference: FirReference) {}

    @FirImplementationDetail
    override fun replaceSource(newSource: KtSourceElement?) {}

    override fun replaceDelegatedConstructorCalls(newDelegatedConstructorCalls: List<FirDelegatedConstructorCall>) {
        if (delegatedConstructorCalls === newDelegatedConstructorCalls) return
        delegatedConstructorCalls.clear()
        delegatedConstructorCalls.addAll(newDelegatedConstructorCalls)
    }
}
