/*
 * Copyright 2010-2022 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.extensions

import ksp.org.jetbrains.kotlin.fir.types.FirQualifierPart
import ksp.org.jetbrains.kotlin.fir.types.FirTypeProjection
import ksp.org.jetbrains.kotlin.fir.types.FirUserTypeRef
import ksp.org.jetbrains.kotlin.fir.types.builder.buildUserTypeRef
import ksp.org.jetbrains.kotlin.fir.types.impl.FirQualifierPartImpl
import ksp.org.jetbrains.kotlin.fir.types.impl.FirTypeArgumentListImpl
import ksp.org.jetbrains.kotlin.name.Name

class QualifierPartBuilder(internal val destination: MutableList<FirQualifierPart>) {
    fun part(name: Name, argumentsBuilder: TypeArgumentsBuilder.() -> Unit = {}) {
        val typeArgumentList = FirTypeArgumentListImpl(source = null)
        TypeArgumentsBuilder(typeArgumentList).argumentsBuilder()
        destination += FirQualifierPartImpl(source = null, name, typeArgumentList)
    }

    class TypeArgumentsBuilder(internal val typeArgumentList: FirTypeArgumentListImpl) {
        fun argument(typeArgument: FirTypeProjection) {
            typeArgumentList.typeArguments += typeArgument
        }
    }
}

fun buildUserTypeFromQualifierParts(
    isMarkedNullable: Boolean,
    builder: QualifierPartBuilder.() -> Unit
): FirUserTypeRef {
    return buildUserTypeRef {
        this.isMarkedNullable = isMarkedNullable
        QualifierPartBuilder(qualifier).builder()
    }
}
