/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.resolve

import ksp.org.jetbrains.kotlin.fir.FirSession
import ksp.org.jetbrains.kotlin.fir.FirSessionComponent
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef

abstract class FirTypeResolver : FirSessionComponent {
    abstract fun resolveType(
        typeRef: FirTypeRef,
        scopeClassDeclaration: ScopeClassDeclaration,
        areBareTypesAllowed: Boolean,
        isOperandOfIsOperator: Boolean,
        resolveDeprecations: Boolean,
        // Note: sometimes we don't have useSiteFile in IDE context
        useSiteFile: FirFile?,
        supertypeSupplier: SupertypeSupplier,
        expandTypeAliases: Boolean = true,
    ): FirTypeResolutionResult
}

data class FirTypeResolutionResult(
    val type: ConeKotlinType,
    val diagnostic: ConeDiagnostic?,
)

val FirSession.typeResolver: FirTypeResolver by FirSession.sessionComponentAccessor()
