/*
 * Copyright 2010-2019 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.fir.symbols.impl

import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration
import ksp.org.jetbrains.kotlin.fir.types.ConeClassifierLookupTag
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol
import ksp.org.jetbrains.kotlin.mpp.ClassifierSymbolMarker

sealed class FirClassifierSymbol<out E : FirDeclaration> : FirBasedSymbol<E>(), ClassifierSymbolMarker {
    abstract fun toLookupTag(): ConeClassifierLookupTag
}
