/*
 * Copyright 2010-2023 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.declarations.lazy

import ksp.org.jetbrains.kotlin.ir.declarations.IrClass
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter
import ksp.org.jetbrains.kotlin.ir.util.deserializedIr

abstract class AbstractIrLazyFunction : IrSimpleFunction(), IrLazyFunctionBase {
    abstract val isDeserializationEnabled: Boolean

    override var dispatchReceiverParameter: IrValueParameter? = null

    override var extensionReceiverParameter: IrValueParameter? = null

    fun tryLoadIr(): Boolean {
        if (!isInline || isFakeOverride) return false
        if (!isDeserializationEnabled) return false
        val toplevelClass = getTopLevelDeclaration() as? IrClass
            ?: return false
        return toplevelClass.deserializedIr?.value ?: false
    }
}