/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.ir.types.impl

import ksp.org.jetbrains.kotlin.descriptors.*
import ksp.org.jetbrains.kotlin.ir.IrFileEntry
import ksp.org.jetbrains.kotlin.ir.LineAndColumn
import ksp.org.jetbrains.kotlin.ir.SourceRangeInfo
import ksp.org.jetbrains.kotlin.ir.UNDEFINED_OFFSET
import ksp.org.jetbrains.kotlin.ir.builders.declarations.addConstructor
import ksp.org.jetbrains.kotlin.ir.declarations.*
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl
import ksp.org.jetbrains.kotlin.ir.util.SYNTHETIC_OFFSET
import ksp.org.jetbrains.kotlin.ir.util.createImplicitParameterDeclarationWithWrappedDescriptor
import ksp.org.jetbrains.kotlin.name.FqName
import ksp.org.jetbrains.kotlin.name.Name
import ksp.org.jetbrains.kotlin.utils.addToStdlib.shouldNotBeCalled

private val ErrorFile = IrFileImpl(
    fileEntry = object : IrFileEntry {
        override val name: String = "<error-class>"
        override val maxOffset: Int
            get() = shouldNotBeCalled()

        override fun getSourceRangeInfo(beginOffset: Int, endOffset: Int): SourceRangeInfo = shouldNotBeCalled()
        override fun getLineNumber(offset: Int): Int = shouldNotBeCalled()
        override fun getColumnNumber(offset: Int): Int = shouldNotBeCalled()
        override fun getLineAndColumnNumbers(offset: Int): LineAndColumn = shouldNotBeCalled()
    },
    symbol = IrFileSymbolImpl(),
    packageFqName = FqName("<error-package>")
)

val IrErrorClassImpl: IrClass = IrFactoryImpl.createClass(
    startOffset = UNDEFINED_OFFSET,
    endOffset = UNDEFINED_OFFSET,
    origin = IrDeclarationOrigin.ERROR_CLASS,
    symbol = IrClassSymbolImpl(),
    name = Name.special("<error>"),
    kind = ClassKind.CLASS,
    visibility = DescriptorVisibilities.DEFAULT_VISIBILITY,
    modality = Modality.FINAL,
    source = SourceElement.NO_SOURCE,
).apply {
    parent = ErrorFile
    createImplicitParameterDeclarationWithWrappedDescriptor()

    // Primary constructor is needed so that we could create annotations with error types in KAPT3+K2.
    // (In KAPT3+K1, error class is created based on ErrorClassDescriptor, which has a primary constructor.)
    addConstructor {
        startOffset = SYNTHETIC_OFFSET
        endOffset = SYNTHETIC_OFFSET
        visibility = DescriptorVisibilities.INTERNAL
        isPrimary = true
    }
}
