/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.js.analyzer

import ksp.org.jetbrains.kotlin.analyzer.AnalysisResult
import ksp.org.jetbrains.kotlin.resolve.BindingTrace
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor
import java.io.File

open class JsAnalysisResult(
        val bindingTrace: BindingTrace,
        moduleDescriptor: ModuleDescriptor,
        shouldGenerateCode: Boolean
) : AnalysisResult(bindingTrace.bindingContext, moduleDescriptor, shouldGenerateCode) {

    companion object {
        @JvmStatic fun success(trace: BindingTrace, module: ModuleDescriptor): JsAnalysisResult {
            return JsAnalysisResult(trace, module, true)
        }

        @JvmStatic fun success(trace: BindingTrace, module: ModuleDescriptor, shouldGenerateCode: Boolean): JsAnalysisResult {
            return JsAnalysisResult(trace, module, shouldGenerateCode)
        }
    }

    class RetryWithAdditionalRoots(
        bindingTrace: BindingTrace,
        moduleDescriptor: ModuleDescriptor,
        val additionalKotlinRoots: List<File>,
    ) : JsAnalysisResult(bindingTrace, moduleDescriptor,false)
}
