/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.factories

import ksp.org.jetbrains.kotlin.backend.common.isBuiltInSuspendCoroutineUninterceptedOrReturn
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression
import ksp.org.jetbrains.kotlin.js.backend.ast.JsInvocation
import ksp.org.jetbrains.kotlin.js.backend.ast.metadata.isSuspend
import ksp.org.jetbrains.kotlin.js.translate.callTranslator.CallInfo
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext
import ksp.org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic

object SuspendCoroutineUninterceptedOrReturnFIF: FunctionIntrinsicFactory {
    override fun getIntrinsic(descriptor: FunctionDescriptor, context: TranslationContext): FunctionIntrinsic? {
        if (!descriptor.isBuiltInSuspendCoroutineUninterceptedOrReturn()) return null
        return Intrinsic
    }
    object Intrinsic: FunctionIntrinsic() {
        override fun apply(callInfo: CallInfo, arguments: List<JsExpression>, context: TranslationContext): JsExpression {
            val lambda = arguments.first()
            val continuation = arguments.last()
            val invocation = JsInvocation(lambda, continuation)
            invocation.isSuspend = true
            return invocation
        }
    }
}