/*
 * Copyright 2000-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.js.translate.intrinsic.operation;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.js.backend.ast.JsExpression;
import ksp.org.jetbrains.kotlin.js.translate.context.TranslationContext;
import ksp.org.jetbrains.kotlin.psi.KtBinaryExpression;

@FunctionalInterface
public interface BinaryOperationIntrinsic {
    @NotNull
    JsExpression invoke(
            @NotNull KtBinaryExpression expression,
            @NotNull JsExpression left,
            @NotNull JsExpression right,
            @NotNull TranslationContext context
    );
}
