/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.light.classes.symbol.parameters

import ksp.com.intellij.psi.PsiIdentifier
import ksp.com.intellij.psi.PsiModifierList
import ksp.com.intellij.psi.PsiType
import ksp.org.jetbrains.annotations.NotNull
import ksp.org.jetbrains.kotlin.asJava.classes.lazyPub
import ksp.org.jetbrains.kotlin.light.classes.symbol.annotations.ComputeAllAtOnceAnnotationsBox
import ksp.org.jetbrains.kotlin.light.classes.symbol.annotations.SymbolLightSimpleAnnotation
import ksp.org.jetbrains.kotlin.light.classes.symbol.classes.SymbolLightClassForInterface
import ksp.org.jetbrains.kotlin.light.classes.symbol.methods.SymbolLightMethodBase
import ksp.org.jetbrains.kotlin.light.classes.symbol.modifierLists.SymbolLightClassModifierList
import ksp.org.jetbrains.kotlin.light.classes.symbol.nonExistentType
import ksp.org.jetbrains.kotlin.psi.KtParameter

internal class SymbolLightParameterForDefaultImplsReceiver(containingDeclaration: SymbolLightMethodBase) :
    SymbolLightParameterBase(containingDeclaration) {
    private val _type by lazyPub {
        (method.containingClass.containingClass as SymbolLightClassForInterface).withClassSymbol {
            val ktType = it.defaultType
            ktType.asPsiType(
                containingDeclaration,
                allowErrorTypes = true,
                getTypeMappingMode(ktType),
                forceValueClassResolution = false,
                allowNonJvmPlatforms = true,
            ) ?: nonExistentType()
        }
    }

    override fun getNameIdentifier(): PsiIdentifier? = null

    override fun getName(): String = "\$this"

    override fun getType(): PsiType = _type

    override fun equals(other: Any?): Boolean =
        other === this || other is SymbolLightParameterForDefaultImplsReceiver && other.parent == parent

    override fun hashCode(): Int = parent.hashCode()

    override fun isVarArgs(): Boolean = false

    private val _modifierList: PsiModifierList by lazyPub {
        SymbolLightClassModifierList(
            this,
            annotationsBox = ComputeAllAtOnceAnnotationsBox { modifierList ->
                listOf(SymbolLightSimpleAnnotation(NotNull::class.java.name, modifierList))
            })
    }

    override fun getModifierList(): PsiModifierList = _modifierList

    override fun hasModifierProperty(name: String): Boolean = false

    override val kotlinOrigin: KtParameter?
        get() = null
}