/*
 * Copyright 2000-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package ksp.org.jetbrains.kotlin.load.kotlin

import ksp.org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor
import ksp.org.jetbrains.kotlin.metadata.deserialization.getExtensionOrNull
import ksp.org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf
import ksp.org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedMemberDescriptor

fun getJvmModuleNameForDeserializedDescriptor(descriptor: DeclarationDescriptor): String? {
    val parent = DescriptorUtils.getParentOfType(descriptor, ClassOrPackageFragmentDescriptor::class.java, false)

    when {
        parent is DeserializedClassDescriptor -> {
            val classProto = parent.classProto
            val nameResolver = parent.c.nameResolver
            return classProto.getExtensionOrNull(JvmProtoBuf.classModuleName)
                ?.let(nameResolver::getString)
                ?: JvmProtoBufUtil.DEFAULT_MODULE_NAME
        }
        descriptor is DeserializedMemberDescriptor -> {
            val source = descriptor.containerSource
            if (source is JvmPackagePartSource) {
                return source.moduleName
            }
        }
    }

    return null
}
