/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.psi

import ksp.com.intellij.lang.ASTNode
import ksp.org.jetbrains.kotlin.KtNodeTypes
import ksp.org.jetbrains.kotlin.name.Name

open class KtExpressionWithLabel(node: ASTNode) : KtExpressionImpl(node) {

    fun getTargetLabel(): KtSimpleNameExpression? {
        @Suppress("USELESS_CAST") // K2 warning suppression, TODO: KT-62472
        return labelQualifier?.findChildByType(KtNodeTypes.LABEL) as? KtSimpleNameExpression
    }

    val labelQualifier: KtContainerNode?
        get() = findChildByType(KtNodeTypes.LABEL_QUALIFIER)

    fun getLabelName(): String? = getTargetLabel()?.getReferencedName()
    fun getLabelNameAsName(): Name? = getTargetLabel()?.getReferencedNameAsName()

    override fun <R, D> accept(visitor: KtVisitor<R, D>, data: D) = visitor.visitExpressionWithLabel(this, data)
}
