/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.psi.stubs.elements;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.psi.KtDotQualifiedExpression;

public class KtDotQualifiedExpressionElementType extends KtPlaceHolderStubElementType<KtDotQualifiedExpression> {
    public KtDotQualifiedExpressionElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtDotQualifiedExpression.class);
    }

    private static boolean checkNodeTypesTraversal(ASTNode node) {

        IElementType type = node.getElementType();
        if (type != KtStubElementTypes.DOT_QUALIFIED_EXPRESSION &&
            type != KtStubElementTypes.REFERENCE_EXPRESSION &&
            type != KtTokens.IDENTIFIER &&
            type != KtTokens.DOT
        ) {
            return false;
        }

        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!checkNodeTypesTraversal(child)) {
                return false;
            }
        }

        return true;
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        ASTNode treeParent = node.getTreeParent();
        if (treeParent == null) return false;

        IElementType parentElementType = treeParent.getElementType();
        if (parentElementType == KtStubElementTypes.IMPORT_DIRECTIVE ||
            parentElementType == KtStubElementTypes.PACKAGE_DIRECTIVE ||
            parentElementType == KtStubElementTypes.VALUE_ARGUMENT ||
            parentElementType == KtStubElementTypes.CLASS_LITERAL_EXPRESSION ||
            parentElementType == KtStubElementTypes.DOT_QUALIFIED_EXPRESSION
        ) {
            return checkNodeTypesTraversal(node) && super.shouldCreateStub(node);
        }

        return false;
    }
}
