/*
 * Copyright 2010-2015 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ksp.org.jetbrains.kotlin.resolve.calls.model;

import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;

public abstract class MutableDataFlowInfoForArguments implements DataFlowInfoForArguments {

    @NotNull protected final DataFlowInfo initialDataFlowInfo;

    public MutableDataFlowInfoForArguments(@NotNull DataFlowInfo initialDataFlowInfo) {
        this.initialDataFlowInfo = initialDataFlowInfo;
    }

    public abstract void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo);
    public abstract void updateResultInfo(@NotNull DataFlowInfo dataFlowInfo);

    @NotNull
    @Override
    public DataFlowInfo getResultInfo() {
        return initialDataFlowInfo;
    }

    public static class WithoutArgumentsCheck extends MutableDataFlowInfoForArguments {

        public WithoutArgumentsCheck(@NotNull DataFlowInfo dataFlowInfo) {
            super(dataFlowInfo);
        }

        @Override
        public void updateInfo(@NotNull ValueArgument valueArgument, @NotNull DataFlowInfo dataFlowInfo) {
            throw new IllegalStateException();
        }

        @Override
        public void updateResultInfo(@NotNull DataFlowInfo dataFlowInfo) {
            throw new IllegalStateException();
        }

        @NotNull
        @Override
        public DataFlowInfo getInfo(@NotNull ValueArgument valueArgument) {
            throw new IllegalStateException();
        }
    };
}
