/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import ksp.org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.FirVariable;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSharedImmutableChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "sharedImmutableClassId", "Lksp/org/jetbrains/kotlin/name/ClassId;", "check", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.native"})
public final class FirNativeSharedImmutableChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirNativeSharedImmutableChecker INSTANCE = new FirNativeSharedImmutableChecker();
    @NotNull
    private static final ClassId sharedImmutableClassId = ClassId.Companion.topLevel(new FqName("kotlin.native.concurrent.SharedImmutable"));

    private FirNativeSharedImmutableChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof FirVariable) {
            if (!(declaration2 instanceof FirValueParameter) || !(CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirPrimaryConstructor)) {
                boolean hasBackingField2;
                boolean bl2 = hasBackingField2 = declaration2 instanceof FirProperty && DeclarationAttributesKt.getHasBackingField((FirProperty)declaration2);
                if ((((FirVariable)declaration2).isVar() || !hasBackingField2) && ((FirVariable)declaration2).getDelegate() == null) {
                    FirNativeHelpersKt.reportIfHasAnnotation(reporter, declaration2, sharedImmutableClassId, FirNativeErrors.INSTANCE.getINAPPLICABLE_SHARED_IMMUTABLE_PROPERTY(), context2);
                }
            }
        } else {
            KtSourceElement ktSourceElement = declaration2.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
            FirNativeHelpersKt.reportIfHasAnnotation(reporter, declaration2, sharedImmutableClassId, FirNativeErrors.INSTANCE.getINAPPLICABLE_SHARED_IMMUTABLE_PROPERTY(), context2);
            return;
        }
        if (!FirHelpersKt.isTopLevel(context2)) {
            FirNativeHelpersKt.reportIfHasAnnotation(reporter, declaration2, sharedImmutableClassId, FirNativeErrors.INSTANCE.getINAPPLICABLE_SHARED_IMMUTABLE_TOP_LEVEL(), context2);
        }
    }
}

