/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.github.benmanes.caffeine.cache;

import java.lang.reflect.Constructor;
import ksp.com.github.benmanes.caffeine.cache.BoundedLocalCache;
import ksp.com.github.benmanes.caffeine.cache.CacheLoader;
import ksp.com.github.benmanes.caffeine.cache.Caffeine;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

final class LocalCacheFactory {
    public static final String MAXIMUM = "maximum";
    public static final String WINDOW_MAXIMUM = "windowMaximum";
    public static final String MAIN_PROTECTED_MAXIMUM = "mainProtectedMaximum";
    public static final String WEIGHTED_SIZE = "weightedSize";
    public static final String WINDOW_WEIGHTED_SIZE = "windowWeightedSize";
    public static final String MAIN_PROTECTED_WEIGHTED_SIZE = "mainProtectedWeightedSize";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String ACCESS_TIME = "accessTime";
    public static final String WRITE_TIME = "writeTime";

    private LocalCacheFactory() {
    }

    static <K, V> BoundedLocalCache<K, V> newBoundedLocalCache(Caffeine<K, V> builder2, @Nullable CacheLoader<? super K, V> cacheLoader, boolean async) {
        StringBuilder sb = new StringBuilder("ksp.com.github.benmanes.caffeine.cache.");
        if (builder2.isStrongKeys()) {
            sb.append('S');
        } else {
            sb.append('W');
        }
        if (builder2.isStrongValues()) {
            sb.append('S');
        } else {
            sb.append('I');
        }
        if (builder2.removalListener != null) {
            sb.append('L');
        }
        if (builder2.isRecordingStats()) {
            sb.append('S');
        }
        if (builder2.evicts()) {
            sb.append('M');
            if (builder2.isWeighted()) {
                sb.append('W');
            } else {
                sb.append('S');
            }
        }
        if (builder2.expiresAfterAccess() || builder2.expiresVariable()) {
            sb.append('A');
        }
        if (builder2.expiresAfterWrite()) {
            sb.append('W');
        }
        if (builder2.refreshAfterWrite()) {
            sb.append('R');
        }
        try {
            Class<?> clazz = Class.forName(sb.toString());
            Constructor<?> ctor = clazz.getDeclaredConstructor(Caffeine.class, CacheLoader.class, Boolean.TYPE);
            BoundedLocalCache factory2 = (BoundedLocalCache)ctor.newInstance(builder2, cacheLoader, async);
            return factory2;
        }
        catch (ReflectiveOperationException e2) {
            throw new IllegalStateException(sb.toString(), e2);
        }
    }
}

