/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.base;

import java.io.Serializable;
import java.util.function.BiPredicate;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.base.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.base.Function;
import ksp.com.google.common.base.FunctionalEquivalence;
import ksp.com.google.common.base.Objects;
import ksp.com.google.common.base.PairwiseEquivalence;
import ksp.com.google.common.base.ParametricNullness;
import ksp.com.google.common.base.Preconditions;
import ksp.com.google.common.base.Predicate;
import ksp.com.google.errorprone.annotations.ForOverride;
import ksp.javax.annotation.CheckForNull;
import ksp.org.checkerframework.checker.nullness.qual.NonNull;
import ksp.org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Equivalence<T>
implements BiPredicate<T, T> {
    protected Equivalence() {
    }

    public final boolean equivalent(@CheckForNull T a2, @CheckForNull T b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return this.doEquivalent(a2, b2);
    }

    @Override
    @Deprecated
    public final boolean test(@CheckForNull T t2, @CheckForNull T u2) {
        return this.equivalent(t2, u2);
    }

    @ForOverride
    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@CheckForNull T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    @ForOverride
    protected abstract int doHash(T var1);

    public final <F> Equivalence<F> onResultOf(Function<? super F, ? extends @Nullable T> function2) {
        return new FunctionalEquivalence<F, T>(function2, this);
    }

    public final <S extends T> Wrapper<S> wrap(@ParametricNullness S reference2) {
        return new Wrapper(this, reference2);
    }

    @GwtCompatible(serializable=true)
    public final <S extends T> Equivalence<Iterable<S>> pairwise() {
        return new PairwiseEquivalence(this);
    }

    public final Predicate<@Nullable T> equivalentTo(@CheckForNull T target) {
        return new EquivalentToPredicate<T>(this, target);
    }

    public static Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return false;
        }

        @Override
        protected int doHash(Object o2) {
            return System.identityHashCode(o2);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class Equals
    extends Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return a2.equals(b2);
        }

        @Override
        protected int doHash(Object o2) {
            return o2.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EquivalentToPredicate<T>
    implements Predicate<T>,
    Serializable {
        private final Equivalence<T> equivalence;
        @CheckForNull
        private final T target;
        private static final long serialVersionUID = 0L;

        EquivalentToPredicate(Equivalence<T> equivalence, @CheckForNull T target) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.target = target;
        }

        @Override
        public boolean apply(@CheckForNull T input) {
            return this.equivalence.equivalent(input, this.target);
        }

        @Override
        public boolean equals(@CheckForNull Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentToPredicate) {
                EquivalentToPredicate that = (EquivalentToPredicate)obj;
                return this.equivalence.equals(that.equivalence) && Objects.equal(this.target, that.target);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.equivalence, this.target);
        }

        public String toString() {
            return this.equivalence + ".equivalentTo(" + this.target + ")";
        }
    }

    public static final class Wrapper<T>
    implements Serializable {
        private final Equivalence<? super @NonNull T> equivalence;
        @ParametricNullness
        private final T reference;
        private static final long serialVersionUID = 0L;

        private Wrapper(Equivalence<? super @NonNull T> equivalence, @ParametricNullness T reference2) {
            this.equivalence = Preconditions.checkNotNull(equivalence);
            this.reference = reference2;
        }

        @ParametricNullness
        public T get() {
            return this.reference;
        }

        public boolean equals(@CheckForNull Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                if (this.equivalence.equals(that.equivalence)) {
                    Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, that.reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            return this.equivalence + ".wrap(" + this.reference + ")";
        }
    }
}

