/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.common.collect;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import ksp.com.google.common.annotations.GwtCompatible;
import ksp.com.google.common.collect.ElementTypesAreNonnullByDefault;
import ksp.com.google.common.collect.Multiset;
import ksp.com.google.common.collect.Multisets;
import ksp.com.google.common.collect.ParametricNullness;
import ksp.com.google.errorprone.annotations.CanIgnoreReturnValue;
import ksp.com.google.errorprone.annotations.concurrent.LazyInit;
import ksp.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractMultiset<E>
extends AbstractCollection<E>
implements Multiset<E> {
    @LazyInit
    @CheckForNull
    private transient Set<E> elementSet;
    @LazyInit
    @CheckForNull
    private transient Set<Multiset.Entry<E>> entrySet;

    AbstractMultiset() {
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean contains(@CheckForNull Object element2) {
        return this.count(element2) > 0;
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean add(@ParametricNullness E element2) {
        this.add(element2, 1);
        return true;
    }

    @Override
    @CanIgnoreReturnValue
    public int add(@ParametricNullness E element2, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean remove(@CheckForNull Object element2) {
        return this.remove(element2, 1) > 0;
    }

    @Override
    @CanIgnoreReturnValue
    public int remove(@CheckForNull Object element2, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @CanIgnoreReturnValue
    public int setCount(@ParametricNullness E element2, int count) {
        return Multisets.setCountImpl(this, element2, count);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean setCount(@ParametricNullness E element2, int oldCount, int newCount) {
        return Multisets.setCountImpl(this, element2, oldCount, newCount);
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean addAll(Collection<? extends E> elementsToAdd) {
        return Multisets.addAllImpl(this, elementsToAdd);
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean removeAll(Collection<?> elementsToRemove) {
        return Multisets.removeAllImpl(this, elementsToRemove);
    }

    @Override
    @CanIgnoreReturnValue
    public final boolean retainAll(Collection<?> elementsToRetain) {
        return Multisets.retainAllImpl(this, elementsToRetain);
    }

    @Override
    public abstract void clear();

    @Override
    public Set<E> elementSet() {
        Set<E> result2 = this.elementSet;
        if (result2 == null) {
            this.elementSet = result2 = this.createElementSet();
        }
        return result2;
    }

    Set<E> createElementSet() {
        return new ElementSet();
    }

    abstract Iterator<E> elementIterator();

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        Set<Multiset.Entry<Multiset.Entry<E>>> result2 = this.entrySet;
        if (result2 == null) {
            this.entrySet = result2 = this.createEntrySet();
        }
        return result2;
    }

    Set<Multiset.Entry<E>> createEntrySet() {
        return new EntrySet();
    }

    abstract Iterator<Multiset.Entry<E>> entryIterator();

    abstract int distinctElements();

    @Override
    public final boolean equals(@CheckForNull Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    public final int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public final String toString() {
        return this.entrySet().toString();
    }

    class EntrySet
    extends Multisets.EntrySet<E> {
        EntrySet() {
        }

        @Override
        Multiset<E> multiset() {
            return AbstractMultiset.this;
        }

        @Override
        public Iterator<Multiset.Entry<E>> iterator() {
            return AbstractMultiset.this.entryIterator();
        }

        @Override
        public int size() {
            return AbstractMultiset.this.distinctElements();
        }
    }

    class ElementSet
    extends Multisets.ElementSet<E> {
        ElementSet() {
        }

        @Override
        Multiset<E> multiset() {
            return AbstractMultiset.this;
        }

        @Override
        public Iterator<E> iterator() {
            return AbstractMultiset.this.elementIterator();
        }
    }
}

