/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.google.devtools.ksp.common;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"copyWithTimestamp", "", "src", "Ljava/io/File;", "dst", "overwrite", "", "common-util"})
public final class IncrementalUtilKt {
    public static final void copyWithTimestamp(@NotNull File src, @NotNull File dst, boolean overwrite) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        if (!dst.getParentFile().exists()) {
            File file = src.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
            File file2 = dst.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
            IncrementalUtilKt.copyWithTimestamp(file, file2, false);
        }
        if (overwrite) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
            Files.copy(src.toPath(), dst.toPath(), copyOptionArray);
        } else {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
            Files.copy(src.toPath(), dst.toPath(), copyOptionArray);
        }
    }
}

