/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.diagnostic;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.com.intellij.diagnostic.CoroutineTraceStripKt;
import ksp.com.intellij.diagnostic.StackframeShrinkVerdict;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0007\u001a\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0002\u001a0\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004H\u0002\u001a0\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b*\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004H\u0002\"\u001e\u0010\u0000\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t*$\b\u0002\u0010\u0012\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u0013"}, d2={"libraryStackframeJudge", "Lkotlin/Function1;", "Ljava/lang/StackTraceElement;", "Lksp/com/intellij/diagnostic/StackframeShrinkVerdict;", "Lksp/com/intellij/diagnostic/StackframeJudge;", "nonLibraryCaseStackframeJudge", "fullName", "", "getFullName", "(Ljava/lang/StackTraceElement;)Ljava/lang/String;", "stripCoroutineTrace", "", "trace", "stripLibraryOnlyTrace", "stripTraceWithNonLibraryFrames", "stripStart", "judge", "stripTail", "StackframeJudge", "intellij.platform.util.base"})
@SourceDebugExtension(value={"SMAP\ncoroutineTraceStrip.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1726#2,3:127\n378#2,7:130\n*S KotlinDebug\n*F\n+ 1 coroutineTraceStrip.kt\ncom/intellij/diagnostic/CoroutineTraceStripKt\n*L\n15#1:127,3\n24#1:130,7\n*E\n"})
public final class CoroutineTraceStripKt {
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> nonLibraryCaseStackframeJudge = nonLibraryCaseStackframeJudge.1.INSTANCE;
    @NotNull
    private static final Function1<StackTraceElement, StackframeShrinkVerdict> libraryStackframeJudge = libraryStackframeJudge.1.INSTANCE;

    @VisibleForTesting
    @NotNull
    public static final List<StackTraceElement> stripCoroutineTrace(@NotNull List<StackTraceElement> trace) {
        boolean bl2;
        block4: {
            Intrinsics.checkNotNullParameter(trace, (String)"trace");
            if (trace.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$all$iv = trace;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    StackTraceElement it = (StackTraceElement)element$iv;
                    boolean bl3 = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null)) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
        }
        return bl2 ? CoroutineTraceStripKt.stripLibraryOnlyTrace(trace) : CoroutineTraceStripKt.stripTraceWithNonLibraryFrames(trace);
    }

    private static final List<StackTraceElement> stripTraceWithNonLibraryFrames(List<StackTraceElement> trace) {
        int lastNonLibFrameIndex;
        block2: {
            int n2;
            List<StackTraceElement> $this$indexOfLast$iv = trace;
            boolean $i$f$indexOfLast = false;
            ListIterator<StackTraceElement> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                StackTraceElement it = iterator$iv.previous();
                boolean bl2 = false;
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
                if (!(!StringsKt.startsWith$default((String)string, (String)"kotlinx.coroutines.", (boolean)false, (int)2, null))) continue;
                n2 = iterator$iv.nextIndex();
                break block2;
            }
            n2 = lastNonLibFrameIndex = -1;
        }
        if (!(lastNonLibFrameIndex != -1)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        return CoroutineTraceStripKt.stripStart(trace.subList(0, lastNonLibFrameIndex + 1), nonLibraryCaseStackframeJudge);
    }

    private static final List<StackTraceElement> stripLibraryOnlyTrace(List<StackTraceElement> trace) {
        return CoroutineTraceStripKt.stripTail(CoroutineTraceStripKt.stripStart(trace, libraryStackframeJudge), libraryStackframeJudge);
    }

    private static final List<StackTraceElement> stripStart(List<StackTraceElement> $this$stripStart, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int startIndex;
        for (startIndex = 0; startIndex < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.OMIT; ++startIndex) {
        }
        while (startIndex + 1 < $this$stripStart.size() && judge.invoke((Object)$this$stripStart.get(startIndex)) == StackframeShrinkVerdict.SHRINK && judge.invoke((Object)$this$stripStart.get(startIndex + 1)) == StackframeShrinkVerdict.SHRINK) {
            ++startIndex;
        }
        return $this$stripStart.subList(startIndex, $this$stripStart.size());
    }

    private static final List<StackTraceElement> stripTail(List<StackTraceElement> $this$stripTail, Function1<? super StackTraceElement, ? extends StackframeShrinkVerdict> judge) {
        int afterLastIndex = $this$stripTail.size();
        while (0 <= afterLastIndex - 1 && judge.invoke((Object)$this$stripTail.get(afterLastIndex - 1)) == StackframeShrinkVerdict.OMIT) {
            --afterLastIndex;
        }
        return $this$stripTail.subList(0, afterLastIndex);
    }

    private static final String getFullName(StackTraceElement $this$fullName) {
        return $this$fullName.getClassName() + '.' + $this$fullName.getMethodName();
    }

    public static final /* synthetic */ String access$getFullName(StackTraceElement $receiver) {
        return CoroutineTraceStripKt.getFullName($receiver);
    }

    public static final /* synthetic */ Function1 access$getLibraryStackframeJudge$p() {
        return libraryStackframeJudge;
    }
}

