/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.lang.impl;

import ksp.com.intellij.lang.impl.MarkerOptionalData;
import ksp.com.intellij.lang.impl.MarkerPool;
import ksp.com.intellij.lang.impl.PsiBuilderImpl;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.it.unimi.dsi.fastutil.ints.IntArrayList;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

final class MarkerProduction
extends IntArrayList {
    private static final Logger LOG = Logger.getInstance(MarkerProduction.class);
    private static final int LINEAR_SEARCH_LIMIT = 20;
    private final MarkerPool myPool;
    private final MarkerOptionalData myOptionalData;

    MarkerProduction(MarkerPool pool, MarkerOptionalData optionalData) {
        super(256);
        this.myPool = pool;
        this.myOptionalData = optionalData;
    }

    void addBefore(PsiBuilderImpl.ProductionMarker marker, PsiBuilderImpl.ProductionMarker anchor) {
        this.add(this.indexOf(anchor), marker.markerId);
    }

    private int indexOf(PsiBuilderImpl.ProductionMarker marker) {
        int idx = this.findLinearly(marker.markerId);
        if (idx < 0) {
            for (int i2 = this.findMarkerAtLexeme(marker.getLexemeIndex(false)); i2 < this.size; ++i2) {
                if (this.a[i2] != marker.markerId) continue;
                idx = i2;
                break;
            }
        }
        if (idx < 0) {
            LOG.error("Dropped or rolled-back marker");
        }
        return idx;
    }

    private int findLinearly(int markerId) {
        int low = Math.max(0, this.size() - 20);
        for (int i2 = this.size() - 1; i2 >= low; --i2) {
            if (this.a[i2] != markerId) continue;
            return i2;
        }
        return -1;
    }

    private int findMarkerAtLexeme(int lexemeIndex) {
        int i2 = ObjectUtils.binarySearch(0, this.size() - 20, mid -> Integer.compare(this.getLexemeIndexAt(mid), lexemeIndex));
        return i2 < 0 ? -1 : this.findSameLexemeGroupStart(lexemeIndex, i2);
    }

    private int findSameLexemeGroupStart(int lexemeIndex, int prodIndex) {
        while (prodIndex > 0 && this.getLexemeIndexAt(prodIndex - 1) == lexemeIndex) {
            --prodIndex;
        }
        return prodIndex;
    }

    void addMarker(PsiBuilderImpl.ProductionMarker marker) {
        this.add(marker.markerId);
    }

    void rollbackTo(PsiBuilderImpl.ProductionMarker marker) {
        int idx = this.indexOf(marker);
        for (int i2 = this.size() - 1; i2 >= idx; --i2) {
            int markerId = this.a[i2];
            if (markerId <= 0) continue;
            this.myPool.freeMarker(this.myPool.get(markerId));
        }
        this.removeElements(idx, this.size());
    }

    boolean hasErrorsAfter(@NotNull PsiBuilderImpl.StartMarker marker) {
        if (marker == null) {
            MarkerProduction.$$$reportNull$$$0(0);
        }
        for (int i2 = this.indexOf(marker) + 1; i2 < this.size(); ++i2) {
            PsiBuilderImpl.ProductionMarker m4 = this.getStartMarkerAt(i2);
            if (m4 == null || !this.hasError(m4)) continue;
            return true;
        }
        return false;
    }

    private boolean hasError(PsiBuilderImpl.ProductionMarker marker) {
        return marker instanceof PsiBuilderImpl.ErrorItem || this.myOptionalData.getDoneError(marker.markerId) != null;
    }

    void dropMarker(@NotNull PsiBuilderImpl.StartMarker marker) {
        if (marker == null) {
            MarkerProduction.$$$reportNull$$$0(1);
        }
        if (marker.isDone()) {
            this.removeInt(this.lastIndexOf(-marker.markerId));
        }
        this.removeInt(this.indexOf(marker));
        this.myPool.freeMarker(marker);
    }

    void addDone(PsiBuilderImpl.StartMarker marker, @Nullable PsiBuilderImpl.ProductionMarker anchorBefore) {
        this.add(anchorBefore == null ? this.size() : this.indexOf(anchorBefore), -marker.markerId);
    }

    @Nullable
    PsiBuilderImpl.ProductionMarker getMarkerAt(int index2) {
        int id = this.getInt(index2);
        return this.myPool.get(id > 0 ? id : -id);
    }

    @Nullable
    PsiBuilderImpl.ProductionMarker getStartMarkerAt(int index2) {
        int id = this.getInt(index2);
        return id > 0 ? this.myPool.get(id) : null;
    }

    @Nullable
    PsiBuilderImpl.StartMarker getDoneMarkerAt(int index2) {
        int id = this.getInt(index2);
        return id < 0 ? (PsiBuilderImpl.StartMarker)this.myPool.get(-id) : null;
    }

    int getLexemeIndexAt(int productionIndex) {
        int id = this.getInt(productionIndex);
        return this.myPool.get(Math.abs(id)).getLexemeIndex(id < 0);
    }

    void confineMarkersToMaxLexeme(int markersBefore, int lexemeIndex) {
        for (int k2 = markersBefore - 1; k2 > 1; --k2) {
            boolean done;
            int id = this.a[k2];
            PsiBuilderImpl.ProductionMarker marker = this.myPool.get(Math.abs(id));
            boolean bl2 = done = id < 0;
            if (marker.getLexemeIndex(done) < lexemeIndex) break;
            marker.setLexemeIndex(lexemeIndex, done);
        }
    }

    void doHeavyChecksOnMarkerDone(@NotNull PsiBuilderImpl.StartMarker doneMarker, @Nullable PsiBuilderImpl.StartMarker anchorBefore) {
        if (doneMarker == null) {
            MarkerProduction.$$$reportNull$$$0(2);
        }
        int idx = this.indexOf(doneMarker);
        int endIdx = this.size();
        if (anchorBefore != null && idx > (endIdx = this.indexOf(anchorBefore))) {
            LOG.error("'Before' marker precedes this one.");
        }
        for (int i2 = endIdx - 1; i2 > idx; --i2) {
            Throwable debugAllocOther;
            PsiBuilderImpl.StartMarker otherMarker;
            PsiBuilderImpl.ProductionMarker item = this.getStartMarkerAt(i2);
            if (!(item instanceof PsiBuilderImpl.StartMarker) || (otherMarker = (PsiBuilderImpl.StartMarker)item).isDone()) continue;
            Throwable debugAllocThis = this.myOptionalData.getAllocationTrace(doneMarker);
            Throwable currentTrace = new Throwable();
            if (debugAllocThis != null) {
                ExceptionUtil.makeStackTraceRelative(debugAllocThis, currentTrace).printStackTrace(System.err);
            }
            if ((debugAllocOther = this.myOptionalData.getAllocationTrace(otherMarker)) != null) {
                ExceptionUtil.makeStackTraceRelative(debugAllocOther, currentTrace).printStackTrace(System.err);
            }
            LOG.error("Another not done marker added after this one. Must be done before this.");
        }
    }

    void assertNoDoneMarkerAround(@NotNull PsiBuilderImpl.StartMarker pivot) {
        if (pivot == null) {
            MarkerProduction.$$$reportNull$$$0(3);
        }
        int pivotIndex = this.indexOf(pivot);
        for (int i2 = pivotIndex + 1; i2 < this.size(); ++i2) {
            PsiBuilderImpl.StartMarker m4 = this.getDoneMarkerAt(i2);
            if (m4 != null && m4.myLexemeIndex <= pivot.myLexemeIndex && this.indexOf(m4) < pivotIndex) {
                throw new AssertionError("There's a marker of type '" + m4.getTokenType() + "' that starts before and finishes after the current marker. See cause for its allocation trace.", this.myOptionalData.getAllocationTrace(m4));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doneMarker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pivot";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/lang/impl/MarkerProduction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorsAfter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "dropMarker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doHeavyChecksOnMarkerDone";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assertNoDoneMarkerAround";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

