/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.fileTypes;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ksp.com.intellij.openapi.fileTypes.FileType;
import ksp.com.intellij.openapi.fileTypes.LanguageFileType;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class CharsetUtil {
    private static final Map<String, Boolean> ourSupportsCharsetDetection = new ConcurrentHashMap<String, Boolean>();

    private static boolean overridesExtractCharsetFromContent(LanguageFileType fileType) {
        Class<?> ftClass = fileType.getClass();
        String methodName = "extractCharsetFromFileContent";
        Class<?> declaring1 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, String.class);
        Class<?> declaring2 = ReflectionUtil.getMethodDeclaringClass(ftClass, methodName, Project.class, VirtualFile.class, CharSequence.class);
        return !LanguageFileType.class.equals(declaring1) || !LanguageFileType.class.equals(declaring2);
    }

    public static Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile virtualFile, @Nullable FileType fileType, @NotNull CharSequence text) {
        if (text == null) {
            CharsetUtil.$$$reportNull$$$0(0);
        }
        if (fileType instanceof LanguageFileType && ourSupportsCharsetDetection.computeIfAbsent(fileType.getName(), __ -> CharsetUtil.overridesExtractCharsetFromContent((LanguageFileType)fileType)).booleanValue()) {
            return ((LanguageFileType)fileType).extractCharsetFromFileContent(project, virtualFile, text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "ksp/com/intellij/openapi/fileTypes/CharsetUtil", "extractCharsetFromFileContent"));
    }
}

